## **CTF Write-up: Undercover Fleet**

### **Challenge Overview**

* **Category:** OSINT / Maritime Intelligence  
* **Difficulty:** Medium  
* **Scenario:** An automated audit of archival satellite imagery from **Airbus Pléiades Neo** has revealed a suspicious industrial crate (possibly containing a missile) on the aft deck of a vessel in the North-Central Atlantic.  
* **Objective:** Identify the vessel and reconstruct its 2025 port history to determine where the cargo was loaded.

---

### **Step 1: Identifying the Target**

The primary lead is the **IMINT (Imagery Intelligence)** report provided by MAOC-N, which contains a specific timestamp and coordinate:

* **Timestamp:** 03 DEC 2025 | 10:47 PM (UTC)  
* **Coordinates:** 19.5084, \-49.6377

**Solution:** Investigators must use a historical **AIS (Automatic Identification System)** tracking tool like **Global Fishing Watch**, **MarineTraffic**, or **VesselFinder**. By searching for all vessel traffic at these exact coordinates on Dec 3, 2025, only one ship matches the location and reported speed of 16.5 knots.

* **Result:** The vessel is identified as the **Guria**.

---

### **Step 2: Vessel Verification**

Once the name is found, players must cross-reference the visual description in the IMINT report with the ship’s official registry and photos to confirm the ID.

* **Vessel Name:** Guria  
* **IMO Number:** 9758351  
* **Visual Match:** Registry photos of the *Guria* confirm the deep-blue hull, white observation tower (crow’s nest), and the red purse seine skiff nested at the stern.  
* **Anomaly Check:** The report notes the vessel is traveling at **16.5 knots** without its standard fishing nets. This matches a "transit" profile rather than an active fishing profile.

---

### **Step 3: Reconstructing the 2025 Port History**

To find the flag, players must look up the **"Historical Port Calls"** for IMO 9758351 throughout the year 2025\.

**Chronological Port Sequence:**

1. **Abidjan, Ivory Coast:** The vessel's long-term origin point.  
2. **Mindelo, Cape Verde:** A brief stop on Oct 12, 2025\.  
3. **Las Palmas, Spain:** A 44-day maintenance stay (Oct 15 – Nov 28, 2025\) where the cargo was likely loaded.  
4. **Manzanillo, Panama:** Arrival at the canal on Dec 8, 2025\.  
5. **Posorja, Ecuador:** Final arrival on Dec 12, 2025\.

---

### **Final Flag Construction**

Following the required format (`name_imo_port1_port2_port3_port4_port5`) in all lowercase with periods for spaces:

**`guria_9758351_abidjan.ivory.coast_mindelo.cape.verde_las.palmas.spain_manzanillo.panama_posorja.ecuador`**